<?php

class ListaArquivos{

	public function listarArquivos($pasta){
		$itens = $this->getArquivos($pasta);
		
		for ($j=0; $j < count($itens); $j++) {
			$it = $itens[$j];
			$stat = stat($pasta."/".$it); 
			$sigla = 'Mb';
			$tam = $stat['size']/(1024*1024);
			
			if($tam < 1){
				$tam = $stat['size']/1024;
				$sigla = 'Kb';
			}
			
			$tam = number_format($tam, 3);
			$f = substr($it, (strlen($it)-3), strlen($it));
			$file = $this->getIcone($f);
			
			echo '<tr class="linha">
					<td>
						<img src="/suporte/imagens/'.$file.'.png" align="absmiddle"/>
						<span class="textoMini">' . $f . '</span>
					</td>
					<td class="titulo">' . substr($it, 0, strlen($it)-4) . '</td>
					<td>'.$tam.' '.$sigla.'</td>
					<td align="center">
						<a href="/'.$pasta.'/'.$it.'">
							<img src="/resources/imagens/icones/downloads.png" title="Baixar"/>
						</a>
					</td>
				</tr>
				<tr>
					<td colspan="4" class="borda"></td>
				</tr>';
		}
	}
	
	private function getArquivos($pasta){
		$ponteiro = opendir($pasta);
		$i=0;
		while ($nome_itens = readdir($ponteiro)) {
			$itens[$i] = $nome_itens;
			if($nome_itens!="." & $nome_itens!="..") { $i++; }
		}
		sort($itens);
		return $itens;
	}

	private function getIcone($f){
		$file = "file";
		if($f == "jpg" || $f == "png" || $f == "bmp" || $f == "gif"){ $file = "imagem";}
		else if($f == "exe"){$file = "exe";}
		else if($f == "zip" || $f == "rar"){$file = "rar";}
		else if($f == "pdf"){$file = "pdf";}
		else if($f == "txt"){$file = "txt";}
		return $file;
	}
}
?>