const mix = require('laravel-mix');

/*
 |--------------------------------------------------------------------------
 | Mix Asset Management
 |--------------------------------------------------------------------------
 |
 | Mix provides a clean, fluent API for defining some Webpack build steps
 | for your Laravel applications. By default, we are compiling the CSS
 | file for the application as well as bundling up all the JS files.
 |
 */

mix
    /**
     * AdminDashboard
     */
    .js([
        // 'resources/views/layouts/admin/js/feather-icons/feather.js',
        // 'resources/views/layouts/admin/vendors/perfect-scrollbar/perfect-scrollbar.min.js',
        // 'resources/views/layouts/admin/js/app.js',
        // 'resources/views/layouts/admin/vendors/chartjs/Chart.js',
        // 'resources/views/layouts/admin/js/pages/dashboard.js',
        'resources/views/layouts/admin/js/custom-dashboard.js',
        ],
        'public/admin/js/custom-dashboard.js')

    .styles([
        // 'resources/views/layouts/admin/css/bootstrap.css',
        // 'resources/views/layouts/admin/vendors/perfect-scrollbar/perfect-scrollbar.css',
        //     'resources/views/layouts/admin/css/app.css',
        //     'resources/views/layouts/admin/vendors/chartjs/Chart.min.css',
            'resources/views/layouts/admin/css/custom-dashboard.css',
        ],
        'public/admin/css/custom-dashboard.css')

    .js('resources/js/app.js', 'public/js')
    .postCss('resources/css/app.css', 'public/css', [
        require('postcss-import'),
        require('tailwindcss'),
    ]);

if (mix.inProduction()) {
    mix.version();
}
