<?php

namespace Tests\Unit;

use App\Enums\MesEnum;
use App\Models\InstituicaoFinanceira\BalancetePrestador;
use App\Models\InstituicaoFinanceira\DataLimteEnvioFinanceiro;
use App\Services\Balancete\VerificadorDePrazoLimeteParaEnvio;
use App\Validadores\Balancetes\AplicaRegrasParaCadastroBalancete;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class UploadDoArquivoCsvComBalancetesDasInstituicoesFinanceirasTest extends TestCase
{
    use RefreshDatabase;

    private BalancetePrestador $balancete_ultimo_mes_ano_passado;
    private BalancetePrestador $balancete_mes_passado_deste_ano;
    private BalancetePrestador $balancete_proximo_mes_deste_ano;
    private BalancetePrestador $balancete_data_hoje;
    private DataLimteEnvioFinanceiro $data_limite;

    private AplicaRegrasParaCadastroBalancete $aplicadorRegrasCadastro;
    private array $prestador;

    protected function setUp(): void
    {
        parent::setUp();

        $this->aplicadorRegrasCadastro = new AplicaRegrasParaCadastroBalancete();

        $ano_hoje = date('Y');
        $mes_hoje = date('m');

        $ano_passado = date('Y',mktime(0,0,0,12, 1,$ano_hoje - 1));
        $ano_que_vem = date('Y',mktime(0,0,0,12, 1,(int) $ano_hoje + 1));
        $mes_passado = date('m', strtotime('-1 months', strtotime(date('Y-m-d'))));
        $mes_que_vem = date('m', strtotime('+1 months', strtotime(date('Y-m-d'))));

        $this->balancete_ultimo_mes_ano_passado = new BalancetePrestador([
            'mes_competencia' => MesEnum::DEZ->value,
            'ano_competencia' => $ano_passado
        ]);

        $this->balancete_mes_passado_deste_ano = new BalancetePrestador([
            'mes_competencia' => $mes_passado,
            'ano_competencia' => $ano_hoje,
        ]);

        $this->balancete_proximo_mes_deste_ano = new BalancetePrestador([
            'mes_competencia' => $mes_que_vem,
            'ano_competencia' => $ano_hoje,
        ]);

        $this->balancete_data_hoje = new BalancetePrestador([
            'mes_competencia' => $mes_hoje,
            'ano_competencia' => $ano_hoje,
        ]);

        $this->data_limite = new DataLimteEnvioFinanceiro([
            'competencia' => '2023.1',
            'dia_limite_envio' => 14,
            'valor_multa' => 30.0,
            'status' => 1,
            'instituicao_id' => 40,
        ]);

    }

    /**
     * MOVER ESTE MÉTODO PARA OUTRA CLASSE QUE VALIDA APENAS A CRIAÇÃO E ATUALIZAÇÃO DE BALANCETES.
     */

//    public function test_validador_regras_de_cadastro()
//    {
//        $this->assertFalse($this->aplicadorRegrasCadastro->aplicar([
//            'mes_competencia' => '02',
//            'ano_competencia' => '2023',
//            'prestador' => ['id' => 1, 'instituicao_id' => 40]
//        ]));
//    }

    public function test_upload_do_arquivo_csv_ano_passado(): void
    {
        $verificardorDataLimite = new VerificadorDePrazoLimeteParaEnvio(
            $this->balancete_ultimo_mes_ano_passado,
            $this->data_limite->dia_limite_envio
        );

        $this->assertFalse($verificardorDataLimite->balanceteEstaNoPrazo());
    }

    public function test_upload_do_arquivo_csv_mes_passado(): void
    {
        $verificardorDataLimite = new VerificadorDePrazoLimeteParaEnvio(
            $this->balancete_mes_passado_deste_ano,
            $this->data_limite->dia_limite_envio
        );

        $this->assertFalse($verificardorDataLimite->balanceteEstaNoPrazo());
    }

    public function test_upload_do_arquivo_csv_proximo_mes_deste_ano(): void
    {
        $verificardorDataLimite = new VerificadorDePrazoLimeteParaEnvio(
            $this->balancete_proximo_mes_deste_ano,
            $this->data_limite->dia_limite_envio
        );

        $this->assertTrue($verificardorDataLimite->balanceteEstaNoPrazo());
    }

    public function test_upload_do_arquivo_csv_para_mes_atual(): void
    {
        $verificardorDataLimite = new VerificadorDePrazoLimeteParaEnvio(
            $this->balancete_data_hoje,
            $this->data_limite->dia_limite_envio
        );

        $this->assertTrue($verificardorDataLimite->balanceteEstaNoPrazo());
    }


}
