<?php

namespace Tests\Unit;

use App\Enums\AplicaMultaBalanceteEnum;
use App\Enums\MesEnum;
use App\Models\InstituicaoFinanceira\BalancetePrestador;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;


class BalanceteFinanceiroTest extends TestCase
{
    use RefreshDatabase;

    public function test_criar_balancete_financeiro()
    {
        $balancete = BalancetePrestador::create([
            'mes_competencia' => MesEnum::JAN->value,
            'ano_competencia' => '2023',
            'aplica_multa' => AplicaMultaBalanceteEnum::NAO->value,
            'prestador_id' => null,
        ]);

        $this->assertEquals(new BalancetePrestador(), $balancete);
    }
}
