<?php

namespace Tests\Feature;

use App\Models\Cidade;
use App\Services\Tomador\BuscaCidade;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;

class CidadeTest extends TestCase
{
    use RefreshDatabase;

    private Cidade $cidade1;
    private Cidade $cidade2;

    protected function setUp(): void
    {
        parent::setUp(); // TODO: Change the autogenerated stub

        $this->cidade1 = Cidade::create([
            'nome' => 'PORTO VELHO',
            'codigo' => '1100205',
            'id_estado' => 1
        ]);

        $this->cidade2 = Cidade::create([
            'nome' => 'BELÉM',
            'codigo' => '2700805',
            'id_estado' => 14
        ]);
    }

    public function test_buscar_cidade_pelo_id()
    {
        $cidadeBelem = BuscaCidade::peloId(2);

        $this->assertInstanceOf(Cidade::class, $cidadeBelem);
        $this->assertEquals($cidadeBelem->id, $this->cidade2->id);
        $this->assertEquals($cidadeBelem->codigo, '2700805');
        $this->assertCount(2, Cidade::all());
    }

    public function test_buscar_cidade_pelo_codigo()
    {
        $cidadePortoVelho = BuscaCidade::peloCodigo('1100205');

        $this->assertInstanceOf(Cidade::class, $cidadePortoVelho);
        $this->assertEquals($cidadePortoVelho->nome, 'PORTO VELHO');
    }
}
