<?php

use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\InstituicaoController;
use App\Http\Controllers\InstituicaoFinanceira\AutenticadorInstituicaoFinanceiraController;
use App\Http\Livewire\AgenciaFinanceira__old\AgenciaIndex;
use App\Http\Livewire\BalanceteFinanceiro\BalanceteIndex;
use App\Http\Livewire\InstituicaoFinanceira\FeedbackDeErros;
use App\Http\Livewire\InstituicaoFinanceira\InstituicaoFinanceiraIndex;
use Illuminate\Support\Facades\Route;

/**
 * ----------------------------------------------------------
 * INSTITUIÇÕES FINANCEIRAS - UPLOAD BALANCETE MENSAL
 * ----------------------------------------------------------
 */

Route::get('/autenticarInstituicaoFinanceira/{cnpjInstituicaoPrestadorIdBase64}', AutenticadorInstituicaoFinanceiraController::class);
Route::get('/feedback-erro-autenticarInstituicaoFinanceira', FeedbackDeErros::class)->name('instituicaoFinanceira.error-feedback');

Route::get('/instituicaoFinanceira', InstituicaoFinanceiraIndex::class)->name('instituicaoFinanceira.index');
Route::get('/agenciasFinanceiras', AgenciaIndex::class)->name('agenciasFinanceiras.index');
Route::get('/balancetesFinanceiros', BalanceteIndex::class)->name('balancetesFinanceiros.index');



Route::get('/', function () {
//    return view('welcome');
    return redirect()->route('admin.home');
});

Route::middleware(['auth:sanctum', 'verified'])->get('/dashboard', function () {
    return view('dashboard');
})->name('dashboard');

Route::group(['middleware' => 'auth:sanctum'], function () {
    Route::get('admin/home', [AdminDashboardController::class, 'home'])->name('admin.home');
});

Route::group(['middleware' => 'auth:sanctum'], function () {
    Route::get('instituicoes', [InstituicaoController::class, 'index'])->name('instituicao.index');
});

