<div>
    <div wire:ignore.self class="modal fade" id="detalhesBalanceteModal" tabindex="-1" aria-labelledby="detalhesBalanceteModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="detalhesBalanceteModalLabel">
                        <span class='mdi mdi-checkbox-marked-circle-outline'></span> Detalhes do Balancete
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <div class="modal-body bg-light">

                    <div class="container">

                        @isset($balancete)

                            <div class="alert" style="background-color:lightgoldenrodyellow; color:#666; border:1px solid orange;">
                                <small>
                                    <strong>Balancete emitido em {{ \Carbon\Carbon::parse($balancete->created_at)->format('d/m/Y H:i:s') }}</strong>
                                    <br>
                                    <strong>Emissor:</strong> {{ $balancete->prestador->dadosCadastrais->razao_nome}}

                                    @isset($balancete->prestadorUltimaAlteracao->dadosCadastrais->razao_nome)
                                        <br>
                                        <strong>Atualizado em:</strong> {{ \Carbon\Carbon::parse($balancete->updated_at)->format('d/m/Y H:i:s') }},
                                        por {{ $balancete->prestadorUltimaAlteracao->dadosCadastrais->razao_nome}}
                                    @endisset
                                </small>
                            </div>

                            <table class="table">
                                <tr>
                                    <th style="background-color:#eee !important;">Empresa:</th>
                                    <td>
                                        {{ $balancete->prestador->dadosCadastrais->razao_nome ?? "" }} - {{ $balancete->prestador->dadosCadastrais->cnpj_cpf ?? "" }}

                                    </td>
                                </tr>
                                <tr><th style="background-color:#eee !important;">Competência:</th><td>{{ \App\Enums\MesEnum::from($balancete->mes_competencia)->name }}/{{ $balancete->ano_competencia }}</td></tr>
                                <tr><th style="background-color:#eee !important;">Histórico:</th><td>{{ $balancete->historico ?? "" }}</td></tr>
                            </table>

                            @if($qtdeLancamentos = $balancete->lancamentos->count())

                                <h5 class="mt-4">:: {{ $qtdeLancamentos }} Lancamentos</h5>

                                <hr>

                                <div class="text-end mb-3">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                        <i class="mdi mdi-close"></i> Fechar
                                    </button>
                                </div>

                                <table class="table table-bordered table-striped table-sm" style="font-size:12px;">
                                    <tr style="background-color:#eee !important;">
                                        <th>COSIF</th>
                                        <th>Conta</th>
                                        <th>Descrição da Conta</th>
                                        <th class="text-end">Saldo Anterior (R$)</th>
                                        <th class="text-end">Mov. Mês (R$)</th>
                                        <th class="text-end">Sal. Semestre (R$)</th>
                                        <th class="text-end">Sal. Exercício (R$)</th>
                                        <th class="text-end">Código Serviço</th>
                                        <th class="text-end">Alíquota</th>
                                        <th class="text-end">Cálculo ISS Mês (R$)</th>
                                    </tr>

                                    @foreach($balancete->lancamentos as $lancamento)
                                        <tr>
                                            <td>{{ $lancamento->cosif }}</td>
                                            <td>{{ $lancamento->conta }}</td>
                                            <td>{{ $lancamento->descricao_da_conta }}</td>
                                            <td class="text-end">{{ mysqlToReal($lancamento->saldo_anterio) }}</td>
                                            <td class="text-end">{{ mysqlToReal($lancamento->movimentacao_mes) }}</td>
                                            <td class="text-end">{{ mysqlToReal($lancamento->saldo_semestre) }}</td>
                                            <td class="text-end">{{ mysqlToReal($lancamento->saldo_exercicio) }}</td>
                                            <td class="text-end">{{ $lancamento->codigo_serviço }}</td>
                                            <td class="text-end">{{ mysqlToReal($lancamento->aliquota) }}</td>
                                            <td class="text-end">{{ mysqlToReal($lancamento->calculo_iss_mes) }}</td>
                                        </tr>
                                    @endforeach
                                </table>

                            @endif

                        @endisset

                    </div> <!-- /container form -->

                </div> <!-- /modal-body -->

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="mdi mdi-close"></i> Fechar
                    </button>
                </div>

            </div> <!-- /modal-content -->
        </div> <!-- modal-dialog -->
    </div><!-- /card -->
</div>
