<div>
    <div wire:ignore.self class="modal fade" id="deleteBalanceteModal" tabindex="-1" aria-labelledby="deleteBalanceteModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <form wire:submit.prevent="excluirBalancete">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="deleteBalanceteModalLabel">
                            <span class='mdi mdi-checkbox-marked-circle-outline'></span> Excluir Balancete
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">

                        <div class="container">

                            <x-alerts :alert="$alert" />

                            @if($showFormButtons)

                                <div class="alert text-dark" style="background-color:lightgoldenrodyellow; border:1px solid orange;">
                                    <small>
                                        <strong>Balancete emitido em {{ \Carbon\Carbon::parse($balancete->created_at)->format('d/m/Y H:i:s') }}</strong>
                                        <br>
                                        <strong>Emissor:</strong> {{ $balancete->prestador->dadosCadastrais->razao_nome}}

                                        @isset($balancete->prestadorUltimaAlteracao->dadosCadastrais->razao_nome)
                                            <br>
                                            <strong>Atualizado em:</strong> {{ \Carbon\Carbon::parse($balancete->updated_at)->format('d/m/Y H:i:s') }},
                                            por {{ $balancete->prestadorUltimaAlteracao->dadosCadastrais->razao_nome}}
                                        @endisset
                                    </small>
                                </div>

                                <table class="table">
                                    <tr>
                                        <th style="background-color:#eee !important;">Empresa:</th>
                                        <td>
                                            - {{ $balancete->prestador->dadosCadastrais->razao_nome }}
                                            <br>
                                            {{ $balancete->prestador->dadosCadastrais->cnpj_cpf }}

                                        </td>
                                    </tr>
                                    <tr><th style="background-color:#eee !important;">Competência:</th><td>{{ \App\Enums\MesEnum::from($balancete->mes_competencia)->name }}/{{ $balancete->ano_competencia }}</td></tr>
                                    <tr><th style="background-color:#eee !important;">CNPJ:</th><td>{{ $balancete->prestador->dadosCadastrais->cnpj_cpf }}</td></tr>
                                    <tr><th style="background-color:#eee !important;">Histórico:</th><td>{{ $balancete->historico ?? "" }}</td></tr>
                                    <tr>
                                        <th style="background-color:#eee !important;">Qtde. de Lançamentos:</th>
                                        <td>{{ $balancete->lancamentos->count() }}</td>
                                    </tr>

                                    <!-- detalhes de atualização e exclusão -->

                                    <!-- /detalhes de atualização e exclusão -->

                                </table>

                                <div class="text-danger mb-3">
                                    <strong class="mb-2 d-block">Deseja continuar com o procedimento de exclusão deste balancete?</strong>
                                    <p class="alert alert-danger"><strong>Atenção:</strong> Após o processo de exclusão, este não poderá ser revertido e todos os dados serão apagados do sistema.</p>
                                </div>

                                <div class="form-floating mb-3 mt-3">
                                    <textarea class="form-control @error('motivo_exclusao') is-invalid @enderror"
                                              id="motivo_exclusao"
                                              type="text"
                                              placeholder="Motivo da Exclusão"
                                              wire:model="motivo_exclusao"
                                              style="height: 10rem !important;">
                                    </textarea>
                                    <label for="motivo_exclusao"><strong>Informe o motivo da exclusão:<span class="text-danger">*</span></strong></label>
                                    @error('motivo_exclusao') <div class="invalid-feedback">{{ $message }}</div>@enderror
                                </div>

                            @endif


                        </div> <!-- /container form -->

                    </div> <!-- /modal-body -->

                    @if($showFormButtons)

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:loading.remove>
                                <i class="mdi mdi-close"></i> Não, Cancelar Procedimento!
                            </button>
                            <button type="submit" class="btn btn-danger" wire:target="excluirBalancete" wire:loading.remove>
                                <i class="mdi mdi-check"></i> Sim, Desejo Confirmar a Exclusão!
                            </button>
                            <button type="button" class="btn btn-success disabled" wire:target="excluirBalancete" wire:loading>
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                Aguarde, estamos processando a sua requisição...
                            </button>
                        </div>
                    @endif

                </div> <!-- /modal-content -->
            </form>
        </div> <!-- modal-dialog -->
    </div><!-- /card -->
</div>

