<div>
    <div wire:ignore.self class="modal fade" id="deleteAgenciaModal" tabindex="-1" aria-labelledby="deleteAgenciaModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <form wire:submit.prevent="excluirAgencia">
                <div class="modal-content">
                    <div class="modal-header bg-danger">
                        <h5 class="modal-title text-white" id="deleteAgenciaModalLabel">
                            <span class='mdi mdi-checkbox-marked-circle-outline'></span> Excluir Agência
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">

                        <div class="container">

                            <x-alerts :alert="$alert" />

                            @if($showFormButtons)

                                <div class="text-danger mb-3">Por favor, confirme a exclusão dos dados abaixo:</div>

                                @isset($nome)
                                <table class="table">
                                    <tr><th>Nome:</th><td>{{ $nome }}</td></tr>
                                    <tr><th>Código:</th><td>{{ $codigo }}</td></tr>
                                    <tr><th>CNPJ:</th><td>{{ $cnpj }}</td></tr>
                                    <tr><th>Observações:</th><td>{{ $observacoes }}</td></tr>
                                </table>
                                @endisset

                            @endif


                        </div> <!-- /container form -->

                    </div> <!-- /modal-body -->

                    @if($showFormButtons)

                        <div class="modal-footer">
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:loading.remove>
                                <i class="mdi mdi-close"></i> Não, Cancelar Procedimento!
                            </button>
                            <button type="submit" class="btn btn-danger" wire:target="excluirAgencia" wire:loading.remove>
                                <i class="mdi mdi-check"></i> Sim, Desejo Confirmar a Exclusão!
                            </button>
                            <button type="button" class="btn btn-success disabled" wire:target="excluirAgencia" wire:loading>
                                <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                Aguarde, estamos processando a sua requisição...
                            </button>
                        </div>
                    @endif

                </div> <!-- /modal-content -->
            </form>
        </div> <!-- modal-dialog -->
    </div><!-- /card -->
</div>

