<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
{{--    <meta name="csrf-token" content="{{ csrf_token() }}">--}}

    <title>{{ config('app.name', 'Laravel') }}</title>

    <link rel="stylesheet" href="{{ asset('/themes/bootswatch/dist/cosmo/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/themes/bootswatch/docs/_vendor/bootstrap-icons/font/bootstrap-icons.css') }}">
    <link rel="stylesheet" href="{{ asset('/themes/bootswatch/docs/_vendor/prismjs/themes/prism-okaidia.css') }}">
    <link rel="stylesheet" href="{{ asset('/themes/bootswatch/docs/_assets/css/custom.min.css') }}">
{{--    <link rel="stylesheet" href="{{ asset('/vendor/datatables.net-bs4/css/dataTables.bootstrap4.css') }}">--}}

    <!-- Fonts -->
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Nunito:wght@400;600;700&display=swap">

    <script type="module" src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.esm.js"></script>
    <script nomodule src="https://unpkg.com/ionicons@5.5.2/dist/ionicons/ionicons.js"></script>

    @stack('styles')

    @livewireStyles
</head>
<body class="bg-light">

    <div class="navbar navbar-expand-lg fixed-top navbar-light" style="background-color:#e2e8f0;">
        <div class="container-fluid">
            <a href="{{ route('instituicaoFinanceira.index') }}" class="navbar-brand text-center">
                <div class="text-center">
                    <img src="{{ asset('images/brasoes/08923971000115.png') }}" alt="" class="img-circle mr-3" style="max-width:40px; margin: 0 auto;">
                </div>
                <span class="d-block mt-2" style="font-size: small"><strong>{{ session()->get('instituicao')->nome }}</strong></span>
                <span class="d-block text-dark" style="font-size: small">CNPJ: {{ session()->get('instituicao')->cnpj }}</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarResponsive" aria-controls="navbarResponsive" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarResponsive">

                <div class="btn-group ms-md-auto" role="group" aria-label="Button group with nested dropdown">
                    <div class="btn-group" role="group">
                        <button id="btnGroupDrop1" type="button" class="btn btn-dark dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ session()->get('prestador')->dadosCadastrais->razao_nome }}
                        </button>
                        <ul class="dropdown-menu" aria-labelledby="btnGroupDrop1">
                            <li><a class="dropdown-item" href="#"><ion-icon name="exit-outline"></ion-icon> Sair</a></li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <!-- Page Content -->
    <main class="container-fluid mt-lg-5 p-4">
        {{ $slot }}
    </main>

    <script src="{{ asset('/themes/bootswatch/docs/_vendor/bootstrap/dist/js/bootstrap.bundle.js') }}"></script>
    <script src="{{ asset('/themes/bootswatch/docs/_vendor/prismjs/prism.js') }}" data-manual></script>
    <script src="{{ asset('/admin/js/custom-dashboard.js') }}"></script>

    <script src="{{ asset('/js/jquery.min.js') }}"></script>

{{--    <script src="{{ asset('/vendor/DataTables/datatables.min.js') }}"></script>--}}

    <!-- masks -->
{{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.10/jquery.mask.js"></script>--}}
    <script src="{{ asset('/js/jquery.masks.js') }}"></script>

    <script>

        $(".cnpj").keydown(function(){
            try {
                $(".cnpj").unmask();
            } catch (e) {}

            let tamanho = $('.cnpj').val().length;

            if(tamanho < 14){
                $(".cnpj").mask("99.999.999\/9999-99");
            }
            // ajustando foco
            let elem = this;
            setTimeout(function(){
                // mudo a posição do seletor
                elem.selectionStart = elem.selectionEnd = 10000;
            }, 0);
            // reaplico o valor para mudar o foco
            let currentValue = $(this).val();
            $(this).val('');
            $(this).val(currentValue);
        });


        /**
         * Start DataTable JQuery
         */
        // $('#start_datatable').DataTable({
        //     language: {
        //         url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/pt-BR.json',
        //     },
        // });
        //
        // window.addEventListener('contentChanged', event => {
        //     console.log('chagamos aquiiiiii');
        //     $('#start_datatable').DataTable({
        //         language: {
        //             url: 'https://cdn.datatables.net/plug-ins/1.11.5/i18n/pt-BR.json',
        //         },
        //     });
        // });

    </script>



    @stack('script')

    @livewireScripts
</body>
</html>

