<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTomadorNotaFiscalsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tomador_nota_fiscal', function (Blueprint $table) {
            $table->id();
            $table->string('razao_nome_tomador')->nullable();
            $table->string('cnpj_cpf_tomador')->nullable();
            $table->string('cep_tomador')->nullable();
            $table->string('bairro_tomador')->nullable();
            $table->string('rua_tomador')->nullable();
            $table->string('numero_tomador')->nullable();
            $table->string('complemento_tomador')->nullable();
            $table->string('email_tomador')->nullable();
            $table->string('telefone_tomador')->nullable();
            $table->string('ramal_tomador')->nullable();

            $table->string('inscricao_estadual')->nullable();
            $table->string('inscricao_municipal')->nullable();
            $table->string('cidade_estrangeira')->nullable();

            $table->integer('tipo_pessoa_tomador')->nullable();
            $table->integer('pais')->nullable();
            $table->timestamps();

            $table->integer('id_cidade_tomador')->nullable();
//            $table->unsignedBigInteger('id_cidade_tomador')->nullable();
//            $table->foreign('id_cidade_tomador')
//                ->references('id')->on('cidades')
//                ->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tomador_nota_fiscal');
    }
}
