<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('lancamentos_financeiros', function (Blueprint $table) {
            $table->id();
            $table->string('cosif');
            $table->string('conta');
            $table->string('descricao_da_conta');
            $table->decimal('saldo_anterio', 10,2)->nullable();
            $table->decimal('movimentacao_mes', 10,2)->nullable();
            $table->decimal('saldo_semestre', 10,2)->nullable();
            $table->decimal('saldo_exercicio', 10,2)->nullable();
            $table->decimal('codigo_serviço', 10,2)->nullable();
            $table->decimal('aliquota', 10,2)->nullable();
            $table->decimal('calculo_iss_mes', 10,2)->nullable();

            $table->foreignId('balancete_id')->nullable()->constrained('balancetes_prestadores');
            $table->foreignId('prestador_id')->nullable()->constrained('prestador');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('lancamentos_financeiros');
    }
};
