<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('balancetes_prestadores', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid');
            $table->string('mes_competencia');
            $table->string('ano_competencia');
            $table->text('historico')->nullable();
            $table->text('path_arquivo_csv')->nullable();

            $table->tinyInteger('aplica_multa'); //referente ao enum AplicaMultaBalanceteEnum

            $table->foreignId('prestador_id')->nullable()->constrained('prestador'); //criador
            $table->foreignId('prestador_ultima_atualizacao_id')->nullable()->constrained('prestador');
            $table->foreignId('prestador_exclusao_id')->nullable()->constrained('prestador');

            $table->softDeletes();
            $table->string('motivo_exclusao')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('balancetes_prestadores');
    }
};
