<?php

use App\Enums\StatusEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRpsTable extends Migration
{
    public function up()
    {
        Schema::create('rps', function (Blueprint $table) {
            $table->id();
            $table->integer('rps_id');
            $table->string('numero');
            $table->string('serie');
            $table->tinyInteger('tipo')->unsigned();
            $table->dateTime('data_emissao');
            $table->tinyInteger('natureza_operacao');
            $table->tinyInteger('regime_especial_tributacao');
            $table->tinyInteger('optante_simples_nacional');
            $table->tinyInteger('incentivador_cultural');
            $table->string('competencia');
            $table->tinyInteger('status')->unsigned()->default(StatusEnum::NORMAL);

            $table->decimal('valor_servicos', 10,2)->nullable();
            $table->decimal('valor_deducoes', 10,2)->nullable();
            $table->decimal('valor_pis', 10,2)->nullable();
            $table->decimal('valor_cofins', 10,2)->nullable();
            $table->decimal('valor_inss', 10,2)->nullable();
            $table->decimal('valor_ir', 10,2)->nullable();
            $table->decimal('valor_csll', 10,2)->nullable();
            $table->decimal('valor_iss_retido', 10,2)->nullable();
            $table->decimal('valor_iss', 10,2)->nullable();
            $table->decimal('outras_retencoes', 10,2)->nullable();
            $table->decimal('aliquota', 10,2)->nullable();
            $table->decimal('desconto_incondicionado', 10,2)->nullable();
            $table->decimal('desconto_condicionado', 10,2)->nullable();

            $table->integer('item_listaServico')->nullable();
            $table->integer('codigo_cnae')->nullable();
            $table->integer('codigo_tributacao_municipio')->nullable();

            $table->text('discriminacao')->nullable();
            $table->integer('codigo_municipio')->nullable();

            $table->string('cpf_cnpj_tomador');
            $table->string('razao_social_tomador');
            $table->string('endereco_tomador');
            $table->string('numero_tomador');
            $table->string('complemento_tomador');
            $table->string('bairro_tomador');
            $table->string('codigo_municipal_tomador');
            $table->string('uF_tomador');
            $table->string('cep_tomador');
            $table->string('telefone_tomador');
            $table->string('email_tomador');

            $table->unsignedBigInteger('lote_id')->nullable();
            $table->foreign('lote_id')
                ->references('id')->on('lotes')
                ->onDelete('cascade');

            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('rps');
    }
}
