<?php

namespace App\View\Components;

use Illuminate\View\Component;

class Alerts extends Component
{
    public $showAlert = false;
    public $type;
    public $title;
    public $description;
    public $xCloseAlert;

    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct(?array $alert, $xCloseAlert = null)
    {
        if (!is_null($alert) && count($alert) > 0) {
            $this->showAlert    = $alert['show'] ?? false;
            $this->type         = $alert['type'] ?? "";
            $this->title        = $alert['title'] ?? "";
            $this->description  = $alert['description'] ?? "";
            $this->xCloseAlert  = $xCloseAlert ?? false;
        }
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        return view('components.alerts');
    }
}
