<?php

namespace App\Validadores\LoteRps;

use App\Models\Lote;
use App\Services\Instituicao\BuscaInstituicao;

/**
 * ------------------------------------------------------------------------
 *
 * Responsável pela aplicação da cadeia de validações de regras de negócio,
 * a partir da implementação do Pattern Chain of Responsibility.
 *
 * ------------------------------------------------------------------------
 */
class ValidadorLotesRps
{
    /**
     * Responsável por iniciar a cadeia de validações para o lote.
     * @param array $data
     * @return mixed
     * @throws \Exception
     */
    public function validar(array $data)
    {
        $instituicao = BuscaInstituicao::buscarPorCodigoDaCidade($data['CodigoCidadeCadastroPrestador']);

        $lote = new Lote();
        $lote->loteRpsId                        = $data['LoteRpsId'];
        $lote->numero                           = $data['NumeroLote'];
        $lote->cnpj                             = $data['Cnpj'];
        $lote->inscricaoMunicipal               = $data['InscricaoMunicipal'];
        $lote->codigo_cidade_cadastro_prestador = $data['CodigoCidadeCadastroPrestador'];
        $lote->quantidadeRps                    = $data['QuantidadeRps'];
        $lote->instituicao_id                   = $instituicao->id;
        $lote['tamanhoDoArrayDeRps']            = count($data['rpsDoLote']);

        $validacoes = new LoteJaCadastrado(
            new InstituicaoInvalida(
                new InscricaoMunicipalContribuinteInvalida(
                    new QuantidadeDeRpsDivergenteDaQuantidadeDoLote(
                        new PrestadorInvalido(
                            new UsuarioPrestadorInvalido(
                                new SemValidacao()
                            )
                        )
                    )
                )
            )
        );

        return $validacoes->validar($lote);
    }
}
