<?php

namespace App\Validadores\LoteRps;

use App\Models\Lote;
use Exception;

class QuantidadeDeRpsDivergenteDaQuantidadeDoLote extends AbstractLoteRpsValidator
{
    /**
     * @throws Exception
     */
    public function validar(Lote $lote)
    {
        if ($lote->tamanhoDoArrayDeRps !== (int) $lote->quantidadeRps)
            throw new Exception("O número de unidades de rps informado não confere com a quantidade de rps informada para o lote.");

        return $this->proximoLote->validar($lote);
    }
}
