<?php

namespace App\Validadores\LoteRps;

use App\Models\DadosCadastrais;
use App\Models\Lote;
use App\Models\Prestador;
use App\Services\Prestador\BuscaPrestador;
use Exception;

class PrestadorInvalido extends AbstractLoteRpsValidator
{

    /**
     * @throws Exception
     */
    public function validar(Lote $lote)
    {
        $prestador = BuscaPrestador::buscar($lote, null);

        if (!$prestador)
            throw new Exception(
                "Prestador não cadastrado no sistema. Por favor, verifique se o Prestador
                {$lote->cnpj} está cadastrado do Portal da Nota Fiscal Eletrônica."
            );

        return $this->proximoLote->validar($lote);
    }
}
