<?php

namespace App\Validadores\LoteRps;

use App\Models\Lote;
use Exception;

class LoteJaCadastrado extends AbstractLoteRpsValidator
{

    /**
     * @throws Exception
     */
    public function validar(Lote $lote)
    {
        if ($this->loteJaCadastrado($lote->numero, $lote->cnpj)) {
            throw new Exception(
                "COD: 105 - Já existe um Lote RPS registrado no sistema com o número informado: {$lote->numero}.
                Por favor, corrija o número do lote atual e reenvie o arquivo.");
        }

        return $this->proximoLote->validar($lote);
    }

    /**
     * @param string $loteNumero
     * @param string $loteCnpj
     * @return bool
     */
    private function loteJaCadastrado(string $loteNumero, string $loteCnpj) : bool
    {
        $lote = Lote::where('numero', $loteNumero)
            ->where('cnpj', $loteCnpj)
            ->first();

        if (!$lote) return false;

        return true;
    }
}
