<?php

namespace App\Validadores\Balancetes;

use App\Enums\MesEnum;
use App\Models\InstituicaoFinanceira\BalancetePrestador;
use Exception;
use RuntimeException;

class CompetenciaJaCadastrada extends AbstractRegrasCadastrarBalanceteValidator
{

    /**
     * @param array $balancete
     * @throws RuntimeException
     */
    public function validar(array $balancete)
    {
        try {

            if ($this->competenciaParaBalanceteJaCadastradaNoBancoDeDados($balancete)) {

                $mes_competencia = MesEnum::from($balancete['mes_competencia'])->name;

                throw new RuntimeException(
                    "Já existem um balancete cadastrado com essa mesma competência: {$mes_competencia}/{$balancete['ano_competencia']}");
            }

            return $this->proximaValidacao->validar($balancete);

        } catch (Exception $exception) {
            throw new RuntimeException($exception->getMessage());
        }
    }

    /**
     * @param array $balancete
     * @return bool
     */
    private function competenciaParaBalanceteJaCadastradaNoBancoDeDados(array $balancete): bool
    {
        try {

            $balancete_ja_cadastrado = BalancetePrestador::where('ano_competencia', $balancete['ano_competencia'])
                ->where('mes_competencia', $balancete['mes_competencia'])
                ->where('prestador_id', $balancete['prestador']['id'])
                ->where('deleted_at', null)
                ->first();

            if (!$balancete_ja_cadastrado) {
                return false;
            }

            if (isset($balancete['id']) && $balancete_ja_cadastrado->id === $balancete['id']) {
                return false;
            }

            return true;

        } catch (Exception $exception) {
            throw new RuntimeException($exception->getMessage());
        }
    }
}
