<?php

namespace App\Validadores\Balancetes;

abstract class AbstractRegrasCadastrarBalanceteValidator
{
    protected ?AbstractRegrasCadastrarBalanceteValidator $proximaValidacao;
    protected string $ano_hoje;
    protected string $mes_hoje;
    protected string $dia_hoje;

    public function __construct(?AbstractRegrasCadastrarBalanceteValidator $balancete)
    {
        $this->proximaValidacao = $balancete;

        $this->ano_hoje = date('Y');
        $this->mes_hoje = date('m');
        $this->dia_hoje = date('d');
    }

    abstract public function validar(array $balancete);
}
