<?php

namespace App\Services\Xml;

class FormataListaRpsCom2OuMais
{
    private $listasRpsDoLote = [];

    public function formatar(array $lote)
    {
        $listaComRpsDoLote = $lote['LoteRps']['ListaRps']['Rps'];

        foreach ($listaComRpsDoLote as $rpsSemFormatacao) {
            $rps = [];
            $rps['Id']                         = $rpsSemFormatacao['InfRps']['@attributes']['Id'];
            $rps['NumeroRps']                  = $rpsSemFormatacao['InfRps']['IdentificacaoRps']['Numero'];
            $rps['Serie']                      = $rpsSemFormatacao['InfRps']['IdentificacaoRps']['Serie'];
            $rps['Tipo']                       = $rpsSemFormatacao['InfRps']['IdentificacaoRps']['Tipo'];
            $rps['DataEmissaoRps']             = $rpsSemFormatacao['InfRps']['DataEmissao'];
            $rps['NaturezaOperacao']           = $rpsSemFormatacao['InfRps']['NaturezaOperacao'];
            $rps['RegimeEspecialTributacao']   = $rpsSemFormatacao['InfRps']['RegimeEspecialTributacao'];
            $rps['OptanteSimplesNacional']     = $rpsSemFormatacao['InfRps']['OptanteSimplesNacional'];
            $rps['IncentivadorCultural']       = $rpsSemFormatacao['InfRps']['IncentivadorCultural'];
            $rps['Competencia']                = $rpsSemFormatacao['InfRps']['Competencia'];
            $rps['Status']                     = $rpsSemFormatacao['InfRps']['Status'];

            //Serviços - Valores
            $rps['ValorServicos']              = $rpsSemFormatacao['InfRps']['Servico']['Valores']['ValorServicos'];
            $rps['ValorDeducoes']              = $rpsSemFormatacao['InfRps']['Servico']['Valores']['ValorDeducoes'];
            $rps['ValorPis']                   = $rpsSemFormatacao['InfRps']['Servico']['Valores']['ValorPis'];
            $rps['ValorCofins']                = $rpsSemFormatacao['InfRps']['Servico']['Valores']['ValorCofins'];
            $rps['ValorInss']                  = $rpsSemFormatacao['InfRps']['Servico']['Valores']['ValorInss'];
            $rps['ValorIr']                    = $rpsSemFormatacao['InfRps']['Servico']['Valores']['ValorIr'];
            $rps['ValorCsll']                  = $rpsSemFormatacao['InfRps']['Servico']['Valores']['ValorCsll'];

            if (!isset($rpsSemFormatacao['InfRps']['Servico']['Valores']['IssRetido'])) {
                throw new \Exception(
                    "a Tag XML 'IssRetido' não foi encontrada em seu arquivo de RPS.
                    por favor, revise seu arquivo XML adicionando a tag 'IssRetido',
                    considerando os valores inteiros: 1 (Sim) e 2 (Não).
                    Se tiver dúvidas, confira no Manual do WebService: https://webservice.e-ticons.com.br/manual/WS-Eticons.pdf
                    ");
            } else {
                $rps['RetencaoIss']                = $rpsSemFormatacao['InfRps']['Servico']['Valores']['IssRetido']; // 1 - sim ou 2 - não.
            }

            $rps['ValorIssRetido']             = $rpsSemFormatacao['InfRps']['Servico']['Valores']['ValorIssRetido'];
            $rps['ValorIss']                   = $rpsSemFormatacao['InfRps']['Servico']['Valores']['ValorIss'];
            $rps['OutrasRetencoes']            = $rpsSemFormatacao['InfRps']['Servico']['Valores']['OutrasRetencoes'];
            $rps['Aliquota']                   = $rpsSemFormatacao['InfRps']['Servico']['Valores']['Aliquota'];
            $rps['DescontoIncondicionado']     = $rpsSemFormatacao['InfRps']['Servico']['Valores']['DescontoIncondicionado'];
            $rps['DescontoCondicionado']       = $rpsSemFormatacao['InfRps']['Servico']['Valores']['DescontoCondicionado'];

            //Serviços
            $rps['ItemListaServico']           = $rpsSemFormatacao['InfRps']['Servico']['ItemListaServico'];
            $rps['CodigoCnae']                 = $rpsSemFormatacao['InfRps']['Servico']['CodigoCnae'];
            $rps['CodigoTributacaoMunicipio']  = $rpsSemFormatacao['InfRps']['Servico']['CodigoTributacaoMunicipio'];
            $rps['Discriminacao']              = $rpsSemFormatacao['InfRps']['Servico']['Discriminacao'];
            $rps['CodigoMunicipioServico']     = $rpsSemFormatacao['InfRps']['Servico']['CodigoMunicipio'];

            //Tomador

            /**
             * ------------------------------------------------------------------
             * Verifica se o campo xml vem com a tag Cpf ou Cnpj.
             * ------------------------------------------------------------------
             */
            $cpfCnpj = null;

            if (isset($rpsSemFormatacao['InfRps']['Tomador']['IdentificacaoTomador']['CpfCnpj']['Cnpj']))
                $cpfCnpj = $rpsSemFormatacao['InfRps']['Tomador']['IdentificacaoTomador']['CpfCnpj']['Cnpj'];

            if (isset($rpsSemFormatacao['InfRps']['Tomador']['IdentificacaoTomador']['CpfCnpj']['Cpf']))
                $cpfCnpj = $rpsSemFormatacao['InfRps']['Tomador']['IdentificacaoTomador']['CpfCnpj']['Cpf'];

            $rps['CpfCnpjTomador'] = $cpfCnpj;
            $rps['RazaoSocialTomador']                = $rpsSemFormatacao['InfRps']['Tomador']['RazaoSocial'];
            $rps['EnderecoTomador']                   = $rpsSemFormatacao['InfRps']['Tomador']['Endereco']['Endereco'];
            $rps['NumeroEnderecoTomador']             = $rpsSemFormatacao['InfRps']['Tomador']['Endereco']['Numero'];
            $rps['ComplementoTomador']                = $rpsSemFormatacao['InfRps']['Tomador']['Endereco']['Complemento'];
            $rps['BairroTomador']                     = $rpsSemFormatacao['InfRps']['Tomador']['Endereco']['Bairro'];
            $rps['CodigoMunicipioTomador']            = $rpsSemFormatacao['InfRps']['Tomador']['Endereco']['CodigoMunicipio'];
            $rps['UfTomador']                         = $rpsSemFormatacao['InfRps']['Tomador']['Endereco']['Uf'];
            $rps['CepTomador']                        = $rpsSemFormatacao['InfRps']['Tomador']['Endereco']['Cep'];

            //Contato
            $rps['TelefoneTomador']                   = empty($rpsSemFormatacao['InfRps']['Tomador']['Contato']['Telefone']) ?: "";
            $rps['EmailTomador']                      = empty($rpsSemFormatacao['InfRps']['Tomador']['Contato']['Email']) ?: "";

            array_push($this->listasRpsDoLote, $rps);
        }

        return $this->listasRpsDoLote;
    }
}
