<?php

namespace App\Services\Tomador;

use App\Models\TomadorNotaFiscal;
use PHPUnit\Exception;

class CriaTomadorNotaFiscal
{
    private string $razao_nome_tomador;
    private string $cnpj_cpf_tomador;
    private string $cep_tomador;
    private string $bairro_tomador;
    private string $rua_tomador;
    private string $numero_tomador;
    private string $complemento_tomador;
    private string $email_tomador;
    private string $telefone_tomador;
    private string $ramal_tomador;
    private string $inscricao_estadual;
    private string $inscricao_municipal;
    private string $cidade_estrangeira;
    private int $tipo_pessoa_tomador;
    private int $pais;
    private int $id_cidade_tomador;

    public function __construct(
        string $razao_nome_tomador,
        string $cnpj_cpf_tomador,
        string $cep_tomador,
        string $bairro_tomador,
        string $rua_tomador,
        string $numero_tomador,
        string $complemento_tomador,
        string $email_tomador,
        string $telefone_tomador,
        string $ramal_tomador,
        string $inscricao_estadual,
        string $inscricao_municipal,
        string $cidade_estrangeira,
        int $tipo_pessoa_tomador,
        int $pais,
        int $id_cidade_tomador
    )
    {
        $this->razao_nome_tomador = $razao_nome_tomador;
        $this->cnpj_cpf_tomador = $cnpj_cpf_tomador;
        $this->cep_tomador = $cep_tomador;
        $this->bairro_tomador = $bairro_tomador;
        $this->rua_tomador = $rua_tomador;
        $this->numero_tomador = $numero_tomador;
        $this->complemento_tomador = $complemento_tomador;
        $this->email_tomador = $email_tomador;
        $this->telefone_tomador = $telefone_tomador;
        $this->ramal_tomador = $ramal_tomador;
        $this->inscricao_estadual = $inscricao_estadual;
        $this->inscricao_municipal = $inscricao_municipal;
        $this->cidade_estrangeira = $cidade_estrangeira;
        $this->tipo_pessoa_tomador = $tipo_pessoa_tomador;
        $this->pais = $pais;
        $this->id_cidade_tomador = $id_cidade_tomador;
    }

    public function criar()
    {
        try {
            $tomadorNota = TomadorNotaFiscal::create([
                'razao_nome_tomador' => $this->razao_nome_tomador,
                'cnpj_cpf_tomador' => $this->cnpj_cpf_tomador,
                'cep_tomador' => $this->cep_tomador,
                'bairro_tomador' => $this->bairro_tomador,
                'rua_tomador' => $this->rua_tomador,
                'numero_tomador' => $this->numero_tomador,
                'complemento_tomador' => $this->complemento_tomador,
                'email_tomador' => $this->email_tomador,
                'telefone_tomador' => $this->telefone_tomador,
                'ramal_tomador' => $this->ramal_tomador,
                'inscricao_estadual' => $this->inscricao_estadual,
                'inscricao_municipal' => $this->inscricao_municipal,
                'cidade_estrangeira' => $this->cidade_estrangeira,
                'tipo_pessoa_tomador' => $this->tipo_pessoa_tomador,
                'pais' => $this->pais,
                'id_cidade_tomador' => $this->id_cidade_tomador
            ]);

            return $tomadorNota;

        }catch (Exception $exception) {
            return $exception->getMessage() . ' - Linha: ' . $exception->getLine();
        }
    }
}
