<?php

namespace App\Services\Rps;

use App\Models\Rps;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class RpsPersist
{
    /**
     * @throws Exception
     */
    public static function store(array $rpsDoLote, int $lote_id)
    {
        if (!count($rpsDoLote) > 0)
            throw new Exception("Não há RPS para salvar no Banco de Dados.");

        try {

            foreach ($rpsDoLote as $rps) {
                self::createRps($rps, $lote_id);
            }

            return true;

        } catch (Exception $exception) {
            Log::error("Problemas ao tentar salvar as RPS para o Lote: (RpsPersist:class): " . $exception->getMessage());
            throw new Exception("Problemas ao tentar salvar as RPS para o Lote:
            Por favor, verifique se os valores informados no XML estão de acordo com os tipos de dados orientados no Manual do WebService.");
        }
    }

    /**
     * @throws Exception
     */
    private static function createRps(array $rps, $lote_id)
    {
        try {

            $rpsSalva = new Rps();

            $rpsSalva->rps_id = $rps['Id'];
            $rpsSalva->numero = $rps['NumeroRps'];
            $rpsSalva->serie = $rps['Serie'];
            $rpsSalva->tipo = $rps['Tipo'];
            $rpsSalva->data_emissao = $rps['DataEmissaoRps'];
            $rpsSalva->natureza_operacao = $rps['NaturezaOperacao'];
            $rpsSalva->regime_especial_tributacao = $rps['RegimeEspecialTributacao'];
            $rpsSalva->optante_simples_nacional = $rps['OptanteSimplesNacional'];
            $rpsSalva->incentivador_cultural = $rps['IncentivadorCultural'];
            $rpsSalva->competencia = $rps['Competencia'];
            $rpsSalva->status = $rps['Status'];

            $rpsSalva->valor_servicos = $rps['ValorServicos'];
            $rpsSalva->valor_deducoes = $rps['ValorDeducoes'];
            $rpsSalva->valor_pis = $rps['ValorPis'];
            $rpsSalva->valor_cofins = $rps['ValorCofins'];
            $rpsSalva->valor_inss = $rps['ValorInss'];
            $rpsSalva->valor_ir = $rps['ValorIr'];
            $rpsSalva->valor_csll = $rps['ValorCsll'];

            $rpsSalva->retencao_iss = $rps['RetencaoIss'];
            $rpsSalva->valor_iss_retido = $rps['ValorIssRetido'];
            $rpsSalva->valor_iss = $rps['ValorIss'];

            $rpsSalva->outras_retencoes = $rps['OutrasRetencoes'];
            $rpsSalva->aliquota = $rps['Aliquota'];
            $rpsSalva->desconto_incondicionado = $rps['DescontoIncondicionado'];
            $rpsSalva->desconto_condicionado = $rps['DescontoCondicionado'];

            $rpsSalva->item_listaServico = $rps['ItemListaServico'];
            $rpsSalva->codigo_cnae = $rps['CodigoCnae'];
            $rpsSalva->codigo_tributacao_municipio = $rps['CodigoTributacaoMunicipio'];

            $rpsSalva->discriminacao = $rps['Discriminacao'];
            $rpsSalva->codigo_municipio = $rps['CodigoMunicipioServico'];

            $rpsSalva->cpf_cnpj_tomador = $rps['CpfCnpjTomador'];
            $rpsSalva->razao_social_tomador = $rps['RazaoSocialTomador'];
            $rpsSalva->endereco_tomador = $rps['EnderecoTomador'];
            $rpsSalva->numero_tomador = $rps['NumeroEnderecoTomador'];
            $rpsSalva->complemento_tomador = $rps['ComplementoTomador'];
            $rpsSalva->bairro_tomador = $rps['BairroTomador'];
            $rpsSalva->codigo_municipal_tomador = $rps['CodigoMunicipioTomador'];
            $rpsSalva->uF_tomador = $rps['UfTomador'];
            $rpsSalva->cep_tomador = $rps['CepTomador'];
            $rpsSalva->telefone_tomador = $rps['TelefoneTomador'];
            $rpsSalva->email_tomador = $rps['EmailTomador'];

            $rpsSalva->lote_id = $lote_id;

            $rpsSalva->save();

            return $rpsSalva;

        } catch (Exception $exception) {
            throw new Exception($exception->getMessage());
        }
    }
}
