<?php

namespace App\Services\Prestador;

use App\Models\Prestador;
use PHPUnit\Exception;

class CriaPrestador
{
    private $assinatura_digital;
    private $nome_representante;
    private $cpf_representante;
    private $id_dados_cadastrais;

    /**
     * @param $assinatura_digital
     * @param $nome_representante
     * @param $cpf_representante
     * @param $id_dados_cadastrais
     */
    public function __construct(string $assinatura_digital, string $nome_representante, string $cpf_representante, int $id_dados_cadastrais)
    {
        $this->assinatura_digital = $assinatura_digital;
        $this->nome_representante = $nome_representante;
        $this->cpf_representante = $cpf_representante;
        $this->id_dados_cadastrais = $id_dados_cadastrais;
    }

    public function criar()
    {
        try {
            $prestador = Prestador::create([
                'assinatura_digital'    => $this->assinatura_digital,
                'nome_representante'    => $this->nome_representante,
                'cpf_representante'     => $this->cpf_representante,
                'id_dados_cadastrais'   => $this->id_dados_cadastrais
            ]);

            return $prestador;

        } catch (Exception $exception) {
            return $exception->getMessage() . ' - Linha: ' . $exception->getLine();
        }
    }
}
