<?php

namespace App\Services\Prestador;

use App\Models\NotaFiscalServico;
use App\Models\Prestador;
use App\Models\PrestadorNotaFiscal;
use App\Services\DadosCadastrais\BuscaDadosCadastrais;
use App\Services\Notas\BuscaNumeroDaNota;
use Exception;

class BuscaPrestadorNotaFiscal
{
    /**
     * Verifica na tabela 'numeracao_nota' se já existe, pelo menos, uma nota cadastrada.
     * Se existir:
     * Busca o número da nota e pesquisa pela nota referente na tabela 'nota_fiscal_servico'.
     * A partir da NotaFiscal encontrada, obtem o PrestadorNotaFiscal, a partir do id.
     * Retorna o PrestadorNotaFiscal.
     *
     * Se não existir:
     * Busca os dados do prestador que estão gravados no objeto dadosCadastrais (utilizando o prestador_id)
     * e cria um novo PrestadorNotaFiscal com os dados adquiridos,
     * retornando o novo PrestadorNotaFiscal.
     *
     * @throws Exception
     */
    public static function buscarOuCriarSeNaoExistir(int $prestador_id) : PrestadorNotaFiscal
    {
        try {
            $prestador = Prestador::find($prestador_id);
            $dadosCadastraisPrestador = BuscaDadosCadastrais::porId($prestador->id_dados_cadastrais);

            return (new CriaPrestadorNotaFiscal(
                $dadosCadastraisPrestador->razao_nome,
                $dadosCadastraisPrestador->cep,
                $dadosCadastraisPrestador->cidadeComUf,
                $dadosCadastraisPrestador->bairro,
                $dadosCadastraisPrestador->rua,
                $dadosCadastraisPrestador->numero ?? "",
                $dadosCadastraisPrestador->complemento ?? "",
                $dadosCadastraisPrestador->email ?? "",
                $dadosCadastraisPrestador->telefone ?? "",
                $dadosCadastraisPrestador->ramal ?? "",
                $dadosCadastraisPrestador->tipo_pessoa
            ))->criar();

        } catch (Exception $exception) {
            throw new Exception("Erro ao tentar Buscar ou Criar um PrestadorNotaFiscal." . $exception->getMessage());
        }
    }
}
