<?php

namespace App\Services\Prestador;

use App\Models\Lote;
use Illuminate\Support\Facades\DB;

class BuscaPrestador
{
    public static function buscar(Lote $lote, ?string $codigoCidadeIbge)
    {
        $codigoCidade = !is_null($codigoCidadeIbge) ? $codigoCidadeIbge : $lote->codigo_cidade_cadastro_prestador;

        $prestador = self::consulta($lote->cnpj, $codigoCidade);

        if (is_null($prestador))
            return null;

        return $prestador;
    }

    /**
     * Busca o prestador a partir do CNPJ na tabela dados_cadastrais.
     * @param string $cnpjPrestador
     * @return null
     */
    public static function buscarId(string $cnpjPrestador)
    {
        $prestador = self::consulta($cnpjPrestador);

        return $prestador->id ?? null;
    }

    private static function consulta(string $cnpjPrestador, int $codigoCidade)
    {
        return DB::table('usuarios')
            ->join('prestador', 'prestador.id_usuario', '=', 'usuarios.id')
            ->join('dados_cadastrais', 'prestador.id_dados_cadastrais', '=', 'dados_cadastrais.id')
            ->join('instituicao', 'instituicao.id', '=', 'usuarios.id_instituicao')
            ->join('cidades', 'cidades.id', '=', 'instituicao.id_cidade')
            ->where('usuarios.cpf_cnpj', $cnpjPrestador)
            ->whereNotNull(['dados_cadastrais.inscricao_municipal'])
            ->where('cidades.codigo', $codigoCidade)
            ->select([
                'prestador.id',
                'prestador.assinatura_digital',
                'prestador.data_solicitacao',
                'prestador.data_liberacao',
                'prestador.protocolo',
                'prestador.regime_tributacao',
                'prestador.optante_simples',
                'prestador.nome_representante',
                'prestador.cpf_representante',
                'prestador.logomarca',
                'prestador.situacao',
                'prestador.data_alteracao',

                'prestador.id_instituicao',
                'prestador.id_usuario',
                'prestador.id_dados_cadastrais',
                'prestador.id_contador',
            ])
            ->first();
    }
}
