<?php

namespace App\Services\Notas;

use App\Models\NumeracaoNota;

class IncrementaNumeroNota
{
    /**
     * @param int $prestador_id
     * @return int
     * @throws \Exception
     */
    public static function incrementar(int $prestador_id) : int
    {
        $numeracaoNota = NumeracaoNota::where('id_prestador', $prestador_id)
            ->orderBy('numero', 'desc')
            ->first();

        if (!$numeracaoNota)
            throw new \Exception("O prestador informado não possui cadastro no sistema. Por favor, realize o seu cadastro e repita a operação.");

        $numeroIncrementado = $numeracaoNota->numero + 1;

        NumeracaoNota::where('id_prestador', $prestador_id)
            ->update(['numero' => $numeroIncrementado]);

        return $numeroIncrementado;
    }
}
