<?php

namespace App\Services\Notas;

use DateTime;
use Exception;
use phpDocumentor\Reflection\Types\This;

class FormataCompetencia
{
    private string $dataNoFormatoVindoNoXml;

    private \DateTime $dataFormatada;

    /**
     * @throws Exception
     */
    public function __construct(string $dataNoFormatoVindoNoXml)
    {
        try {

            $this->dataNoFormatoVindoNoXml = $dataNoFormatoVindoNoXml;
            $this->converteDataStringParaDateTime();

        } catch (Exception $exception) {
            throw new Exception($exception->getMessage());
        }
    }

    /**
     * Formato a string 'competencia' que vem no xml no seguinte formato: 202109.
     * Necessário converter para datetime para padronização do banco de dados da NotaFiscal.
     *
     * @param string $competencia
     * @return string
     */
    public function mes()
    {
        return $this->dataFormatada->format('n');
    }

    public function ano()
    {
        return $this->dataFormatada->format("Y");
    }

    public function anoMesDia()
    {
        return $this->dataFormatada->format("Y-m-d H:i:s");
    }

    /**
     * @throws Exception
     */
    private function converteDataStringParaDateTime()
    {
        try {

            $ano = substr($this->dataNoFormatoVindoNoXml, 0, 4);
            $mes = substr($this->dataNoFormatoVindoNoXml, 4, 2);
            $dia = '01';

            $this->dataFormatada = new \DateTime("{$ano}-{$mes}-{$dia}");

        } catch (Exception $exception) {
            throw new Exception("Formato inválido para o campo 'Competencia'. Use Ano e Mês. Exemplo: 202201");
        }
    }

}
