<?php

namespace App\Services\Notas;

class FormataCodigoDeVerificacaoNota
{
    /**
     * Formata o código de verificação da nota a partir da concatenação do ID do prestador com o número da nota.
     *
     * @param string $prestador_id
     * @param string $numero_da_nota
     * @return string
     */
    public static function get(string $prestador_id, string $numero_da_nota): string
    {
        $num_para_codigo = $prestador_id . $numero_da_nota;
        $num_base_16 = base_convert($num_para_codigo, 10, 16);

        if (strlen($num_base_16) < 8) {
            $num_base_16 = str_pad($num_base_16, 8, 0, STR_PAD_RIGHT);
        }

        return strtoupper($num_base_16);
    }
}
