<?php

namespace App\Services\Notas;

use App\Models\NumeracaoNota;
use Exception;

class BuscaNumeroDaNota
{
    /**
     * Busca o número da última nota salva na tabela numeracao_nota.
     * Se ainda não há nenhuma nota salva, retorna o número 1 (um),
     * que será utilizado para iniciar a sequência da numeração para a nota.
     * O número retornado será formatado com 0 (zeros) à esquerda,
     * para ser uma string de tamanho 7.
     *
     * @param int|null $prestador_id
     * @return string
     * @throws Exception
     */
    public static function buscarOuGerarSeNaoExistir(int $prestador_id = null): string
    {
        if (is_null($prestador_id))
            throw new Exception("Não foi possível buscar o número da última Nota Fiscal do Prestador, pois o prestadorId é nulo.");

        $ultimoNumeroCadastrado = NumeracaoNota::where('id_prestador', $prestador_id)
            ->orderBy('numero', 'desc')
            ->first();

        if ($ultimoNumeroCadastrado)
            $numero = $ultimoNumeroCadastrado->numero + 1;
        else
            $numero = 1;

        return str_pad($numero, 7, 0, STR_PAD_LEFT);
    }

    /**
     * Busca o número da última nota salva na tabela numeracao_nota.
     * Se ainda não há nenhuma nota salva, retorna false.
     * Se existir, retorna o número, que será formatado com 0 (zeros) à esquerda,
     * para ser uma string de tamanho 7.
     *
     * @param int|null $prestador_id
     * @return int
     * @throws Exception
     */
    public static function buscarApenasSeExistir(int $prestador_id = null): string
    {
        if (is_null($prestador_id))
            throw new Exception("Não foi possível buscar o número da última Nota Fiscal do Prestador, pois o prestadorId é nulo.");

        $ultimoNumeroCadastrado = NumeracaoNota::where('id_prestador', $prestador_id)
            ->orderBy('numero', 'desc')
            ->first();

        if (!$ultimoNumeroCadastrado)
            return false;

        return str_pad($ultimoNumeroCadastrado->numero, 7, 0, STR_PAD_LEFT);
    }
}
