<?php

namespace App\Services\Lotes;

use Illuminate\Support\Facades\DB;

class SalvaLoteApi
{

    /**
     * @throws \Exception
     */
    public function salvar(array $lote)
    {
        try {
            DB::beginTransaction();

            $loteSalvo = LotePersist::store($lote);

            DB::commit();

            return $loteSalvo;

        } catch (\Exception $exception) {
            DB::rollBack();
            throw new \Exception("Erro ao tentar salvar o lote." . $exception->getMessage());
        }
    }
}
