<?php

namespace App\Services\Lotes;

use App\Models\Instituicao;
use App\Models\Lote;
use Illuminate\Support\Facades\DB;
use Exception;

class LotePersist
{
    /**
     * @param array $lote
     * @return mixed
     * @throws Exception
     */
    public static function store(array $lote)
    {
        DB::beginTransaction();

        try {
//            $instituicao = (new BuscaInstituicaoPorCnpjPrestador())->buscar($lote['Cnpj']);
            $instituicao = Instituicao::where('cnpj', $lote['InstituicaoCnpj'])->first();

            $loteSalvo = (new Lote())->create([
                'lote_rps_id'                       => $lote['LoteRpsId'],
                'numero'                            => $lote['NumeroLote'],
                'cnpj'                              => $lote['Cnpj'],
                'inscricao_municipal'               => $lote['InscricaoMunicipal'],
//                'codigo_cidade_cadastro_prestador'  => $lote['CodigoCidadeCadastroPrestador'],
                'quantidade_rps'                    => $lote['QuantidadeRps'],
                'instituicao_id'                    => $instituicao->id,
            ]);

            DB::commit();

            return $loteSalvo;

        } catch (Exception $exception) {
            DB::rollBack();
            throw new Exception("Problemas ao tentar salvar o LoteRps: "
                . $exception->getMessage() . ' - '
                . $exception->getLine() );
        }
    }
}
