<?php

namespace App\Services\Instituicao;

use App\Models\Instituicao;
use Exception;
use Illuminate\Support\Facades\DB;

class BuscaInstituicao
{
    public static function buscar(string $cnpj)
    {
        return Instituicao::where('cnpj', $cnpj)->first();
    }

    /**
     * @throws Exception
     */
    public static function buscarPorCodigoDaCidade(string $codigo)
    {
        try {

            return DB::table('cidades')
                ->join('instituicao', 'instituicao.id_cidade', '=', 'cidades.id')
                ->select('instituicao.*')
                ->where('cidades.codigo', '=', $codigo)
                ->first();

        } catch (Exception $exception) {
            throw new Exception($exception->getMessage());
        }
    }
}
