<?php

namespace App\Services\DadosCadastrais;

use App\Models\DadosCadastrais;
use Exception;

class CriaDadosCadastrais
{
    private string $cnpj_cpf;
    private string $razao_nome;
    private string $inscricao_estadual;
    private string $inscricao_municipal;
    private int $pais;
    private string $cep;
    private string $cidade_estrangeira;
    private string $bairro;
    private string $rua;
    private string $numero;
    private string $complemento;
    private string $email;
    private string $telefone;
    private string $ramal;
    private int $tipo_pessoa;
    private string $contato;
    private int $id_cidade;

    /**
     * @param string $cnpj_cpf
     * @param string $razao_nome
     * @param string $inscricao_estadual
     * @param string $inscricao_municipal
     * @param int $pais
     * @param string $cep
     * @param string $cidade_estrangeira
     * @param string $bairro
     * @param string $rua
     * @param string $numero
     * @param string $complemento
     * @param string $email
     * @param string $telefone
     * @param string $ramal
     * @param int $tipo_pessoa
     * @param string $contato
     * @param int $id_cidade
     */
    public function __construct(
            string $cnpj_cpf,
            string $razao_nome,
            string $inscricao_estadual,
            string $inscricao_municipal,
            int $pais,
            string $cep,
            string $cidade_estrangeira,
            string $bairro,
            string $rua,
            string $numero,
            string $complemento,
            string $email,
            string $telefone,
            string $ramal,
            int $tipo_pessoa,
            string $contato,
            int $id_cidade
    )
    {

        $this->cnpj_cpf = $cnpj_cpf;
        $this->razao_nome = $razao_nome;
        $this->inscricao_estadual = $inscricao_estadual;
        $this->inscricao_municipal = $inscricao_municipal;
        $this->pais = $pais;
        $this->cep = $cep;
        $this->cidade_estrangeira = $cidade_estrangeira;
        $this->bairro = $bairro;
        $this->rua = $rua;
        $this->numero = $numero;
        $this->complemento = $complemento;
        $this->email = $email;
        $this->telefone = $telefone;
        $this->ramal = $ramal;
        $this->tipo_pessoa = $tipo_pessoa;
        $this->contato = $contato;
        $this->id_cidade = $id_cidade;
    }

    /**
     * @throws Exception
     */
    public function criar() : DadosCadastrais
    {

        try {
            $dados = DadosCadastrais::create([
            'cnpj_cpf' => $this->cnpj_cpf,
            'razao_nome' => $this->razao_nome,
            'inscricao_estadual' => $this->inscricao_estadual,
            'inscricao_municipal' => $this->inscricao_municipal,
            'pais' => $this->pais,
            'cep' => $this->cep,
            'cidade_estrangeira' => $this->cidade_estrangeira,
            'bairro' => $this->bairro,
            'rua' => $this->rua,
            'numero' => $this->numero,
            'complemento' => $this->complemento,
            'email' => $this->email,
            'telefone' => $this->telefone,
            'ramal' => $this->ramal,
            'tipo_pessoa' => $this->tipo_pessoa,
            'contato' => $this->contato,
            'id_cidade' => $this->id_cidade,
            ]);

            return $dados;

        } catch (Exception $exception) {
            throw new Exception($exception->getMessage() . ' - Linha: ' . $exception->getLine());
        }
    }
}
