<?php

namespace App\Services\DadosCadastrais;

use App\Models\DadosCadastrais;
use Exception;

class BuscaDadosCadastrais
{
    /**
     * Busca os dados cadastrais a partir do CNPJ ou CPF.
     * @param string $cnpj_cpf
     * @return mixed
     * @throws Exception
     */
    public static function porCnpjOuCpf(string $cnpj_cpf)
    {
        try {

            return DadosCadastrais::where('cnpj_cpf', $cnpj_cpf)->first();

        } catch (Exception $exception) {
            throw new Exception($exception->getMessage());
        }
    }

    /**
     * @throws Exception
     */
    public static function porId(int $dados_cadastrais_id)
    {
        try {

            return DadosCadastrais::where('id', $dados_cadastrais_id)->first();

        }catch (Exception $exception) {
            throw new Exception($exception->getMessage());
        }
    }
}
