<?php

namespace App\Services;

use App\Models\Instituicao;
use App\Models\Prestador;
use App\Services\DadosCadastrais\BuscaDadosCadastrais;
use Exception;
use phpDocumentor\Reflection\Types\This;

class BuscaInstituicaoPorCnpjPrestador
{
    private Instituicao $instituicao;

    /**
     * @param string $cpfCnpjPrestador
     * @return Instituicao
     * @throws Exception
     */
    public function buscar(string $cpfCnpjPrestador) : Instituicao
    {
        try {

            $dadosDoPrestador = BuscaDadosCadastrais::porCnpjOuCpf($cpfCnpjPrestador);

            if (!$dadosDoPrestador)
                throw new Exception("Os Dados Cadastrais para o Prestador '{$cpfCnpjPrestador}' não foram localizados em nosso banco de dados.
                Por favor, verifique no Portal da Nota Fiscal se seus dados estão cadastrados corretamente.");

            $prestador = Prestador::where('id_dados_cadastrais', $dadosDoPrestador->id)->first();

            if (!$prestador)
                throw new Exception("Os Dados Cadastrais para CNPJ/CPF '{$cpfCnpjPrestador}' não estão relacionados com nenhum Prestador.
                Por favor, verifique no Portal da Nota Fiscal se há duplicidade em seu cadastro.");

            $this->instituicao = Instituicao::find($prestador->id_instituicao);

            if (!$this->instituicao)
                throw new Exception("O Prestador para '{$cpfCnpjPrestador}' não está relacionado com nenhuma Instituição.
                Por favor, verifique no Portal da Nota Fiscal se seus dados estão cadastrados corretamente.");


            return $this->instituicao;

        } catch (Exception $exception) {
            throw new Exception($exception->getMessage());
        }
    }
}
