<?php

namespace App\Services\Balancete;

use App\Models\SequencialDam;
use Carbon\Carbon;
use Exception;

class BuscaSequencialDam
{
    /**
     * @param int $instituicao_id
     * @return int
     */
    public static function gerar(int $instituicao_id) : int
    {
        try {

            $sequencial = SequencialDam::where('id_instituicao', $instituicao_id)->first();
            ++$sequencial->numero;
            $sequencial->data_alteracao = Carbon::now();
            $sequencial->exercicio = (int) date('Y');
            $sequencial->save();

            return $sequencial->numero;

        } catch (Exception $exception) {
            throw new \RuntimeException("BuscaSequencialDam - Problema ao tentar garar o sequencial do DAM: " . $exception->getMessage());
        }
    }
}
