<?php

namespace App\Services\AtividadeEconomica;

use App\Models\AtividadeEconomica;
use PHPUnit\Exception;

class CriaAtividadeEconomica
{
    private int $tipo;
    private int $id_prestador;
    private int $id_atividade_economica_classe;
    private int $id_atividade_economica_subclasse;
    private int $situacao;

    /**
     * @param int $tipo
     * @param int $id_prestador
     * @param int $id_atividade_economica_classe
     * @param int $id_atividade_economica_subclasse
     * @param int $situacao
     */
    public function __construct(
        int $tipo,
        int $id_prestador,
        int $id_atividade_economica_classe,
        int $id_atividade_economica_subclasse,
        int $situacao
    )
    {
        $this->tipo = $tipo;
        $this->id_prestador = $id_prestador;
        $this->id_atividade_economica_classe = $id_atividade_economica_classe;
        $this->id_atividade_economica_subclasse = $id_atividade_economica_subclasse;
        $this->situacao = $situacao;
    }

    public function criar()
    {
        try {
            $atividade = AtividadeEconomica::create([
                'tipo' => $this->tipo,
                'id_prestador' => $this->id_prestador,
                'id_atividade_economica_classe' => $this->id_atividade_economica_classe,
                'id_atividade_economica_subclasse' => $this->id_atividade_economica_subclasse,
                'situacao' => $this->situacao,
            ]);

            return $atividade;
        } catch (Exception $exception) {
            return $exception->getMessage() . ' - Linha: ' . $exception->getLine();
        }
    }
}
