<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TomadorNotaFiscal extends Model
{
    use HasFactory;

    protected $table = "tomador_nota_fiscal";

    public $timestamps = false;

    protected $fillable = [
        'razao_nome_tomador',
        'cnpj_cpf_tomador',
        'cep_tomador',
        'bairro_tomador',
        'rua_tomador',
        'numero_tomador',
        'complemento_tomador',
        'email_tomador',
        'telefone_tomador',
        'ramal_tomador',
        'inscricao_estadual',
        'inscricao_municipal',
        'cidade_estrangeira',
        'tipo_pessoa_tomador',
        'pais',

        'id_cidade_tomador',
        ];

    public function notasServico()
    {
        return $this->hasMany(NotaFiscalServico::class);
    }

    public function cidade()
    {
        return $this->belongsTo(Cidade::class, 'id_cidade_tomador');
    }
}
