<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PrestadorNotaFiscal extends Model
{
    use HasFactory;

    protected $table = "prestador_nota_fiscal";

    public $timestamps = false;

    protected $fillable = [
        'razao_nome_prestador',
        'cep_prestador',
        'cidade_prestador',
        'bairro_prestador',
        'rua_prestador',
        'numero_prestador',
        'complemento_prestador',
        'email_prestador',
        'telefone_prestador',
        'ramal_prestador',
        'tipo_pessoa_prestador'
    ];

    public function notasServico()
    {
        return $this->hasMany(NotaFiscalServico::class);
    }
}
