<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class NotaFiscalServico extends Model
{
    use HasFactory;

    protected $table = "nota_fiscal_servico";

    public $timestamps = false;

    protected $fillable = [
        'descricao',
        'numero',
        'numero_substituicao',
        'codigo_verificacao',
        'numero_processo',
        'situacao',
        'data_emissao',
        'competencia',
        'competencia_mes',
        'competencia_ano',
        'valor',
        'valor_iss',
        'base_calculo',
        'valor_liquido',
        'deducao_legal',
        'valor_pis',
        'valor_irrf',
        'valor_confins',
        'valor_csll',
        'valor_inss',
        'outras_retencoes',
        'aliquota',
        'data_cancelamento',
        'exigibilidade_iss',
        'retencao_iss',

        'regime_tributacao_prestador',
        'optante_simples_prestador',
        'desconto_condicionado',
        'desconto_incondicionado',
        'pais_incidencia',

        'id_prestador',
        'id_tomador',
        'id_atividade',
        'id_instituicao',
        'id_cidade_prestacao',
        'id_cidade_incidencia',
        'id_dam', // null
        'id_prestador_nota',
        'id_tomador_nota',
        'id_dam_avulso_externo' // null
    ];

    public function prestador()
    {
        return $this->belongsTo(Prestador::class, 'id_prestador');
    }

    public function prestadorNota()
    {
        return $this->belongsTo(PrestadorNotaFiscal::class, 'id_prestador_nota');
    }

    public function tomador()
    {
        return $this->belongsTo(Tomador::class, 'id_tomador');
    }

    public function tomadorNota()
    {
        return $this->belongsTo(TomadorNotaFiscal::class, 'id_tomador_nota');
    }

    public function atividade()
    {
        return $this->belongsTo(AtividadeEconomica::class, 'id_atividade');
    }

    public function instituicao()
    {
        return $this->belongsTo(Instituicao::class, 'id_instituicao');
    }

    public function cidadePrestacao()
    {
        return $this->belongsTo(Cidade::class, 'id_cidade_prestacao');
    }

    public function cidadeIncidencia()
    {
        return $this->belongsTo(Cidade::class, 'id_cidade_incidencia');
    }

    public function loteRpsNota()
    {
        return $this->belongsTo(LotesRpsNotaFiscalServico::class);
    }
}
