<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LotesRpsNotaFiscalServico extends Model
{
    use HasFactory;

    use SoftDeletes;

    protected $table = "lotes_rps_nota_fiscal_servico";

    protected $fillable = [
        'id_lote',
        'id_rps',
        'id_nota'
    ];

    public function lote()
    {
        return $this->belongsTo(Lote::class, 'id_lote');
    }

    public function rps()
    {
        return $this->belongsTo(Rps::class, 'id_rps');
    }

    public function nota()
    {
        return $this->belongsTo(NotaFiscalServico::class, 'id_nota');
    }
}
