<?php

namespace App\Models\InstituicaoFinanceira;

use App\Models\Instituicao;
use App\Traits\PrestadorTenantable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class LimitadorDeEnvio extends Model
{
    use PrestadorTenantable;
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        'uuid', 'dia_limite_envio', 'status', 'instituicao_id', 'prestador_id'
    ];

    public function instituicao()
    {
        return $this->belongsTo(Instituicao::class, 'instituicao_id');
    }

    public static function booted()
    {
        static::creating(function ($model) {
            $model->uuid = (string) Str::uuid();
        });
    }
}
