<?php

namespace App\Models\InstituicaoFinanceira;

use App\Models\Prestador;
use App\Traits\PrestadorTenantable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Session;

class LancamentosFinanceiro extends Model
{
    use PrestadorTenantable;
    use HasFactory;
    use SoftDeletes;

    protected $table = 'lancamentos_financeiros';

    protected $fillable = [
        'cosif',
        'conta',
        'descricao_da_conta',
        'saldo_anterio',
        'movimentacao_mes',
        'saldo_semestre',
        'saldo_exercicio',
        'codigo_serviço',
        'aliquota',
        'calculo_iss_mes',

        'balancete_id',
        'prestador_id',
    ];

    public function balancete(): BelongsTo
    {
        return $this->belongsTo(BalancetePrestador::class, 'balancete_id');
    }

    public function prestador(): BelongsTo
    {
        return $this->belongsTo(Prestador::class, 'prestador_id');
    }

    public static function booted() : void
    {
        static::addGlobalScope('prestador_id', static function (Builder $builder) {
            if (existsInSessionPrestadorTenantId()) {
                $builder->where('prestador_id', Session::get('prestador_id'));
            }
        });
    }
}





