<?php

namespace App\Models\InstituicaoFinanceira;

use App\Models\Instituicao;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class DataLimteEnvioFinanceiro extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $table = 'data_limte_envio_financeiros';

    protected $fillable = [
        'uuid', 'competencia', 'dia_limite_envio', 'valor_multa', 'status', 'instituicao_id'
    ];

    public function instituicao()
    {
        return $this->belongsTo(Instituicao::class, 'instituicao_id');
    }

    public static function booted() : void
    {
        static::creating(static function ($model) {
            $model->uuid = (string) Str::uuid();
        });
    }
}
