<?php

namespace App\Models\InstituicaoFinanceira;

use App\Models\Prestador;
use App\Traits\PrestadorTenantable;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Str;

class BalancetePrestador extends Model
{
    use PrestadorTenantable;
    use HasFactory;
    use SoftDeletes;

    protected $table = 'balancetes_prestadores';

    protected $fillable = [
        'uuid',
        'mes_competencia',
        'ano_competencia',
        'historico',
        'path_arquivo_csv',
        'aplica_multa', // EnumAplicaMultaBalancete

        'motivo_exclusao',

        'prestador_id',
        'prestador_ultima_atualizacao_id',
        'prestador_exclusao_id'
    ];

    public function prestadorUltimaAlteracao(): BelongsTo
    {
        return $this->belongsTo(Prestador::class, 'prestador_ultima_atualizacao_id');
    }

    public function prestadorExclusao(): BelongsTo
    {
        return $this->belongsTo(Prestador::class, 'prestador_exclusao_id');
    }

    public function lancamentos(): HasMany
    {
        return $this->hasMany(LancamentosFinanceiro::class, 'balancete_id');
    }

    public static function booted() : void
    {
        static::creating(static function ($model) {
            $model->uuid = (string) Str::uuid();
        });

        static::addGlobalScope('prestador_id', static function (Builder $builder) {
            if (existsInSessionPrestadorTenantId()) {
                $builder->where('prestador_id', Session::get('prestador_id'));
            }
        });
    }
}
