<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Instituicao extends Model
{
    use HasFactory;

    protected $table = "instituicao";

    protected $fillable = [
        'nome',
        'cnpj',
        'situacao',
        'datainclusao',
        'data_alteracao',
        'email',
        'rua' ,
        'numero',
        'bairro' ,
        'cep',
        'complemento' ,
        'telefone',
        'logomarca',
        'link_acesso_sistema',
        'multa',
        'juros',
        'aliquota',
        'dia_vencimento',
        'tipo_boleto',
        'dia_limite_cancelamento',

        'id_cidade',
    ];

    public function lotes()
    {
        return $this->hasMany(Lote::class);
    }

    public function notasServico()
    {
        return $this->hasMany(NotaFiscalServico::class);
    }

    public function prestadores()
    {
        return $this->hasMany(Prestador::class);
    }

    public function cidade()
    {
        return $this->belongsTo(Cidade::class, 'id_cidade');
    }
}
