<?php

namespace App\Models;

use App\Enums\UfEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DadosCadastrais extends Model
{
    use HasFactory;

    protected $table = "dados_cadastrais";

    public $timestamps = false;

    protected $fillable = [
        'cnpj_cpf',
        'razao_nome',
        'inscricao_estadual',
        'inscricao_municipal',
        'pais',
        'cep',
        'cidade_estrangeira',
        'bairro',
        'rua',
        'numero',
        'complemento',
        'email',
        'telefone',
        'ramal',
        'tipo_pessoa',
        'contato',

        'id_cidade',
    ];

    public function cidade()
    {
        return $this->belongsTo(Cidade::class, 'id_cidade');
    }

    public function prestadores()
    {
        return $this->hasMany(Prestador::class);
    }

    public function getCidadeComUfAttribute()
    {
        $uf = mb_strtoupper(
            UfEnum::getDescription( (int) $this->cidade->id_estado )
        );

        return $this->cidade->nome . ' / ' . $uf;
    }

    public function getCodigoCidadeAttribute()
    {
        return $this->cidade->codigo;
    }
}
