<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Cidade extends Model
{
    use HasFactory;

    protected $table = "cidades";

    protected $fillable = [
        'nome',
        'codigo',
        'id_estado',
    ];

    public function notasServico()
    {
        return $this->hasMany(NotaFiscalServico::class);
    }

    public function tomadorNota()
    {
        return $this->hasMany(TomadorNotaFiscal::class);
    }

    public function dadosCadastrais()
    {
        return $this->hasMany(DadosCadastrais::class);
    }

    public function instituicao()
    {
        return $this->hasMany(Instituicao::class);
    }
}
